import { verifyJwt } from '../utils/jwt.js';
import pool from '../config/db.js';
export async function authGuard(req, res, next) {
    const token = req.cookies?.token;
    if (!token)
        return res.status(401).json({ error: 'Unauthorized' });
    const payload = verifyJwt(token);
    if (!payload)
        return res.status(401).json({ error: 'Unauthorized' });
    try {
        const [rows] = await pool.query(`SELECT is_disabled FROM users WHERE uid = :uid LIMIT 1`, { uid: payload.sub });
        if (rows && rows.length && Number(rows[0].is_disabled) === 1) {
            return res.status(403).json({ error: 'Account disabled' });
        }
    }
    catch { }
    req.user = payload; // { sub: uid, role }
    next();
}
export function optionalAuth(req, _res, next) {
    const token = req.cookies?.token;
    const payload = token ? verifyJwt(token) : null;
    if (payload)
        req.user = payload;
    next();
}
