import { Router } from 'express';
import pool from '../config/db.js';
import { authGuard } from '../middleware/auth.js';
const router = Router();
// GET /api/notifications - list current user's notifications
router.get('/', authGuard, async (req, res) => {
    const user = req.user;
    const limit = Math.min(Number(req.query.limit ?? 50), 200);
    const offset = Math.max(Number(req.query.offset ?? 0), 0);
    const [u] = await pool.query(`SELECT id FROM users WHERE uid = :uid LIMIT 1`, { uid: user.sub });
    if (!u || !u.length)
        return res.status(401).json({ error: 'Unauthorized' });
    const userId = u[0].id;
    const [rows] = await pool.query(`SELECT id, type, title, message, level, data, is_read as isRead, created_at as createdAt FROM notifications WHERE user_id = :userId ORDER BY created_at DESC LIMIT :limit OFFSET :offset`, { userId, limit, offset });
    res.json({ items: rows, limit, offset });
});
// PATCH /api/notifications/:id/read - mark one as read
router.patch('/:id/read', authGuard, async (req, res) => {
    const user = req.user;
    const id = Number(req.params.id);
    const [u] = await pool.query(`SELECT id FROM users WHERE uid = :uid LIMIT 1`, { uid: user.sub });
    if (!u || !u.length)
        return res.status(401).json({ error: 'Unauthorized' });
    const userId = u[0].id;
    await pool.query(`UPDATE notifications SET is_read = 1 WHERE id = :id AND user_id = :userId`, { id, userId });
    res.json({ ok: true });
});
// PATCH /api/notifications/read-all
router.patch('/read-all', authGuard, async (req, res) => {
    const user = req.user;
    const [u] = await pool.query(`SELECT id FROM users WHERE uid = :uid LIMIT 1`, { uid: user.sub });
    if (!u || !u.length)
        return res.status(401).json({ error: 'Unauthorized' });
    const userId = u[0].id;
    await pool.query(`UPDATE notifications SET is_read = 1 WHERE user_id = :userId`, { userId });
    res.json({ ok: true });
});
export default router;
