import 'dotenv/config';
import bcrypt from 'bcryptjs';
import pool from '../config/db.js';
async function seed() {
    const conn = await pool.getConnection();
    try {
        const password = 'password123';
        const hash = await bcrypt.hash(password, 10);
        const devUsers = [
            { email: 'admin@example.com', firstName: 'Admin', lastName: 'User', roleId: 1 },
            { email: 'agent@example.com', firstName: 'Agent', lastName: 'User', roleId: 2 },
            { email: 'client@example.com', firstName: 'Client', lastName: 'User', roleId: 3 },
        ];
        for (const u of devUsers) {
            const [rows] = await conn.query('SELECT id FROM users WHERE email = :email LIMIT 1', { email: u.email });
            if (Array.isArray(rows) && rows.length > 0) {
                // Ensure role and password are as expected
                await conn.query('UPDATE users SET role_id = :roleId, password_hash = :hash, first_name = :first, last_name = :last WHERE email = :email', {
                    roleId: u.roleId, hash, first: u.firstName, last: u.lastName, email: u.email,
                });
                continue;
            }
            const [result] = await conn.query('INSERT INTO users (role_id, email, password_hash, first_name, last_name, is_email_verified, is_verified) VALUES (:roleId, :email, :hash, :first, :last, 1, 1)', { roleId: u.roleId, email: u.email, hash, first: u.firstName, last: u.lastName });
            const userId = String(result.insertId);
            await conn.query(`INSERT INTO user_wallets (user_id, coin_id)
         SELECT :userId, c.id FROM coins c WHERE c.is_active = 1
         AND NOT EXISTS (SELECT 1 FROM user_wallets uw WHERE uw.user_id = :userId AND uw.coin_id = c.id)`, { userId });
        }
        console.log('Dev users seeded. Emails: admin@example.com, agent@example.com, client@example.com | Password: password123');
    }
    finally {
        conn.release();
    }
}
seed().then(() => process.exit(0)).catch((e) => { console.error(e); process.exit(1); });
