import formData from 'form-data';
import Mailgun from 'mailgun.js';
export class MailgunProvider {
    constructor(config, defaultFrom) {
        const mg = new Mailgun(formData);
        this.mg = mg.client({ username: 'api', key: config.apiKey, url: config.baseUrl });
        this.domain = config.domain;
        this.defaultFrom = config.fromOverride || defaultFrom;
    }
    async send(params) {
        const data = {
            to: params.to,
            from: params.from || this.defaultFrom,
            subject: params.subject,
            text: params.text,
            html: params.html,
        };
        const res = await this.mg.messages.create(this.domain, data);
        return { id: res.id || undefined };
    }
}
